
use if age<=65 using "${dir3}mergedCF1_noPA", clear

bysort id: egen tot=count(year)
keep if tot!=. & tot!=1
drop tot

bysort CF1 c_b year: egen pippo=count(year)
bysort CF1 c_b: egen fr_c_new=median(pippo)
keep if fr_c_new<=30

keep n_pols_ing n_pols_out id aged p_b year c_b f_id n_paid_m
merge m:1 f_id using "${dir3}sectors.dta", keep(master matched) keepusing(ateco81 sector_pellegrino pellegrino)
drop _m f_id
egen group=group(ateco81)

global y="n_paid_m"
global i=1
while $i<=50 {

global i=1
while $i<=50 {

cap drop ${y}_sec${i}
g ${y}_sec${i}=${y}*(group==$i)

reghdfe ${y}_sec${i} n_pols_ing n_pols_out, a(id aged p_b#year) vce(cluster c_b)
g coef_empl${i}=_coef[n_pols_ing]
g se_empl${i}=_se[n_pols_ing] 

drop ${y}_sec${i}
global i=$i+1

}

forvalues i=1(1)50 {
   egen n_paid_m`i'=mean(n_paid_m) if group==`i'
   egen m_n_paid_m`i'=mean(n_paid_m`i')
   gen pos_n_paid_m`i'=n_paid_m>0 & n_paid_m!=. & group==`i'
   egen obs_n_paid_m`i'=sum(pos_n_paid_m`i')
   drop n_paid_m`i' pos_n_paid_m`i'
}

compress 

egen tag_sector=tag(ateco81)
keep if tag_sector==1
keep coef* se* m_* obs_* ateco81 sector_pellegrino pellegrino group
saveold "${dir3}coef_n_paid_m_by_sec", replace


use if age<=65 using "${dir3}mergedCF1_noPA", clear

bysort id: egen tot=count(year)
keep if tot!=. & tot!=1
drop tot

bysort CF1 c_b year: egen pippo=count(year)
bysort CF1 c_b: egen fr_c_new=median(pippo)
keep if fr_c_new<=30

keep n_pols_ing n_pols_out id aged p_b year c_b f_id tot_wg
merge m:1 f_id using "${dir3}sectors.dta", keep(master matched) keepusing(ateco81 sector_pellegrino pellegrino)
drop _m f_id
egen group=group(ateco81)

global y="tot_wg"
global i=1
while $i<=50 {

global i=1
while $i<=50 {

cap drop ${y}_sec${i}
g ${y}_sec${i}=${y}*(group==$i)

reghdfe ${y}_sec${i} n_pols_ing n_pols_out, a(id aged p_b#year) vce(cluster c_b)
g coef_empl${i}=_coef[n_pols_ing]
g se_empl${i}=_se[n_pols_ing] 

drop ${y}_sec${i}
global i=$i+1

}

forvalues i=1(1)50 {
   egen tot_wg`i'=mean(tot_wg) if group==`i'
   egen m_tot_wg`i'=mean(tot_wg`i')
   gen pos_tot_wg`i'=tot_wg>0 & tot_wg!=. & group==`i'
   egen obs_tot_wg`i'=sum(pos_tot_wg`i')
   drop tot_wg`i' pos_tot_wg`i'
}

compress 

egen tag_sector=tag(ateco81)
keep if tag_sector==1
keep coef* se* m_* obs_* ateco81 sector_pellegrino pellegrino group
saveold "${dir3}coef_tot_wg_by_sec", replace


use if age<=65 using "${dir3}mergedCF1_noPA", clear

bysort id: egen tot=count(year)
keep if tot!=. & tot!=1
drop tot

bysort CF1 c_b year: egen pippo=count(year)
bysort CF1 c_b: egen fr_c_new=median(pippo)
keep if fr_c_new<=30

keep n_pols_ing n_pols_out id aged p_b year c_b f_id empl
merge m:1 f_id using "${dir3}sectors.dta", keep(master matched) keepusing(ateco81 sector_pellegrino pellegrino)
drop _m f_id
egen group=group(ateco81)

global y="empl"
global i=1
while $i<=25 {

cap drop ${y}_sec${i}
g ${y}_sec${i}=${y}*(group==$i)

reghdfe ${y}_sec${i} n_pols_ing n_pols_out, a(id aged p_b#year) vce(cluster c_b)
g coef_empl${i}=_coef[n_pols_ing]
g se_empl${i}=_se[n_pols_ing] 

drop ${y}_sec${i}
global i=$i+1

}

forvalues i=1(1)25 {
   egen empl`i'=mean(empl) if group==`i'
   egen m_empl`i'=mean(empl`i')
   gen pos_empl`i'=empl>0 & empl!=. & group==`i'
   egen obs_empl`i'=sum(pos_empl`i')
   drop empl`i' pos_empl`i'
}

compress 

egen tag_sector=tag(ateco81)
keep if tag_sector==1
keep coef* se* m_* obs_* ateco81 sector_pellegrino pellegrino group
saveold "${dir3}coef_empl_by_sec1", replace

use if age<=65 using "${dir3}mergedCF1_noPA", clear

bysort id: egen tot=count(year)
keep if tot!=. & tot!=1
drop tot

bysort CF1 c_b year: egen pippo=count(year)
bysort CF1 c_b: egen fr_c_new=median(pippo)
keep if fr_c_new<=30

keep n_pols_ing n_pols_out id aged p_b year c_b f_id empl
merge m:1 f_id using "${dir3}sectors.dta", keep(master matched) keepusing(ateco81 sector_pellegrino pellegrino)
drop _m f_id
egen group=group(ateco81)

global y="empl"
global i=26
while $i<=50 {

cap drop ${y}_sec${i}
g ${y}_sec${i}=${y}*(group==$i)

reghdfe ${y}_sec${i} n_pols_ing n_pols_out, a(id aged p_b#year) vce(cluster c_b)
g coef_empl${i}=_coef[n_pols_ing]
g se_empl${i}=_se[n_pols_ing] 

drop ${y}_sec${i}
global i=$i+1

}

forvalues i=26(1)50 {
   egen empl`i'=mean(empl) if group==`i'
   egen m_empl`i'=mean(empl`i')
   gen pos_empl`i'=empl>0 & empl!=. & group==`i'
   egen obs_empl`i'=sum(pos_empl`i')
   drop empl`i' pos_empl`i'
}

compress 

egen tag_sector=tag(ateco81)
keep if tag_sector==1
keep coef* se* m_* obs_* ateco81 sector_pellegrino pellegrino group
saveold "${dir3}coef_empl_by_sec2", replace
use "${dir3}coef_empl_by_sec2", clear
append using "${dir3}coef_empl_by_sec1"
collapse coef_* se_* m_* obs_* ateco81 sector_pellegrino pellegrino, by(group)
saveold "${dir3}coef_empl_by_sec", replace


* Estimates

use "${dir3}coef_tot_wg_by_sec.dta", clear

merge 1:1 ateco81 using "${dir3}CIS.dta", keep(master matched) keepusing(comp_tot comp_pub)

gen coef_tot_wg=.
gen coef_tot_wg_std=.
gen se_tot_wg=.
gen se_tot_wg_std=.
gen obs_tot_wg=.
forvalues i=1(1)50 { 
   replace coef_tot_wg=coef_tot_wg`i' if group==`i' 
   gen coef_tot_wg_std`i'=coef_tot_wg`i'/m_tot_wg`i' 
   replace coef_tot_wg_std=coef_tot_wg_std`i'*100 if group==`i' 
   drop coef_tot_wg_std`i'
   replace se_tot_wg=se_tot_wg`i' if group==`i' 
   gen se_tot_wg_std`i'=se_tot_wg`i'/sqrt(m_tot_wg`i')
   replace se_tot_wg_std=se_tot_wg_std`i'*100 if group==`i' 
   drop se_tot_wg_std`i' m_tot_wg`i'
   replace obs_tot_wg=obs_tot_wg`i' if group==`i' 
}

gen cis=comp_pub/comp_tot
replace cis=cis/100
foreach var of varlist pellegrino cis {
   gen `var'_miss=`var'==.
   replace `var'=-99 if `var'==.
}
label var pellegrino "Pellegrino and Zingales"
label var cis "CIS - ISTAT"

reg coef_tot_wg_std pellegrino* [aw=1/se_tot_wg_std^2], robust cluster(pellegrino)
outreg2 pellegrino using "${dir5}het_by_sec", tex bdec(3) nocons replace ct(Tot. wg.) label 


use "${dir3}coef_n_paid_m_by_sec.dta", clear

merge 1:1 ateco81 using "${dir3}CIS.dta", keep(master matched) keepusing(comp_tot comp_pub)

gen coef_n_paid_m=.
gen coef_n_paid_m_std=.
gen se_n_paid_m=.
gen se_n_paid_m_std=.
gen obs_n_paid_m=.
forvalues i=1(1)50 { 
   replace coef_n_paid_m=coef_n_paid_m`i' if group==`i' 
   gen coef_n_paid_m_std`i'=coef_n_paid_m`i'/m_n_paid_m`i' 
   replace coef_n_paid_m_std=coef_n_paid_m_std`i'*100 if group==`i' 
   drop coef_n_paid_m_std`i'
   replace se_n_paid_m=se_n_paid_m`i' if group==`i' 
   gen se_n_paid_m_std`i'=se_n_paid_m`i'/sqrt(m_n_paid_m`i') 
   replace se_n_paid_m_std=se_n_paid_m_std`i'*100 if group==`i' 
   drop se_n_paid_m_std`i' m_n_paid_m`i'
   replace obs_n_paid_m=obs_n_paid_m`i' if group==`i' 
}

replace pellegrino=.03197188 if ateco81==24
replace sector_pellegrino=2 if ateco81==24
replace pellegrino=pellegrino/100
gen cis=comp_pub/comp_tot
replace cis=cis/100
foreach var of varlist pellegrino cis {
   gen `var'_miss=`var'==.
   replace `var'=-99 if `var'==.
}
label var pellegrino "Pellegrino and Zingales"
label var cis "CIS - ISTAT"

reg coef_n_paid_m_std pellegrino* [aw=1/se_n_paid_m_std^2], robust cluster(pellegrino)
outreg2 pellegrino using "${dir5}het_by_sec", tex bdec(3) nocons append ct(N. paid m.) label 


use "${dir3}coef_empl_by_sec.dta", clear

merge 1:1 ateco81 using "${dir3}CIS.dta", keep(master matched) keepusing(comp_tot comp_pub)

gen coef_empl=.
gen coef_empl_std=.
gen se_empl=.
gen se_empl_std=.
gen obs_empl=.
forvalues i=1(1)50 { 
   replace coef_empl=coef_empl`i' if group==`i' 
   gen coef_empl_std`i'=coef_empl`i'/m_empl`i' 
   replace coef_empl_std=coef_empl_std`i'*100 if group==`i' 
   drop coef_empl_std`i'
   replace se_empl=se_empl`i' if group==`i' 
   gen se_empl_std`i'=se_empl`i'/sqrt(m_empl`i') 
   replace se_empl_std=se_empl_std`i'*100 if group==`i' 
   drop se_empl_std`i' m_empl`i'
   replace obs_empl=obs_empl`i' if group==`i' 
}

replace pellegrino=.03197188 if ateco81==24
replace sector_pellegrino=2 if ateco81==24
replace pellegrino=pellegrino/100
gen cis=comp_pub/comp_tot
replace cis=cis/100
foreach var of varlist pellegrino cis {
   gen `var'_miss=`var'==.
   replace `var'=-99 if `var'==.
}
label var pellegrino "Pellegrino and Zingales"
label var cis "CIS - ISTAT"

reg coef_empl_std pellegrino* [aw=1/se_empl_std^2], robust cluster(pellegrino)
outreg2 pellegrino using "${dir5}het_by_sec", tex bdec(3) nocons append ct(Empl.) label 
